/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.core;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.ide.syncing.core.DefaultSiteConnection;
import com.aptana.ide.syncing.core.ISiteConnectionManager;
import com.aptana.ide.syncing.core.SiteConnectionManager;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.osgi.framework.BundleContext;

public class SyncingPlugin
extends Plugin {
    public static final String PLUGIN_ID = "com.aptana.syncing.core";
    private static SyncingPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Job job = new Job("Initializing Syncing plugin"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ISavedState lastState = ResourcesPlugin.getWorkspace().addSaveParticipant(SyncingPlugin.PLUGIN_ID, (ISaveParticipant)new WorkspaceSaveParticipant());
                    if (lastState != null) {
                        IPath location = lastState.lookup((IPath)new Path("sites"));
                        if (location != null) {
                            SiteConnectionManager.getInstance().loadState(SyncingPlugin.this.getStateLocation().append(location));
                        }
                        if ((location = lastState.lookup((IPath)new Path("defaultConnection"))) != null) {
                            DefaultSiteConnection.getInstance().loadState(SyncingPlugin.this.getStateLocation().append(location));
                        }
                    }
                }
                catch (IllegalStateException e) {
                    IdeLog.logError((Plugin)SyncingPlugin.getDefault(), (Throwable)e);
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)SyncingPlugin.getDefault(), (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.schedule(3000L);
    }

    public void stop(BundleContext context) throws Exception {
        ResourcesPlugin.getWorkspace().removeSaveParticipant(PLUGIN_ID);
        plugin = null;
        super.stop(context);
    }

    public static SyncingPlugin getDefault() {
        return plugin;
    }

    public static ISiteConnectionManager getSiteConnectionManager() {
        return SiteConnectionManager.getInstance();
    }

    private class WorkspaceSaveParticipant
    implements ISaveParticipant {
        private WorkspaceSaveParticipant() {
        }

        public void prepareToSave(ISaveContext context) throws CoreException {
        }

        public void saving(ISaveContext context) throws CoreException {
            int saveNum = context.getSaveNumber();
            IPath savePath = new Path("sites").addFileExtension(Integer.toString(saveNum));
            SiteConnectionManager.getInstance().saveState(SyncingPlugin.this.getStateLocation().append(savePath));
            context.map((IPath)new Path("sites"), savePath);
            savePath = new Path("defaultConnection").addFileExtension(Integer.toString(saveNum));
            DefaultSiteConnection.getInstance().saveState(SyncingPlugin.this.getStateLocation().append(savePath));
            context.map((IPath)new Path("defaultConnection"), savePath);
            context.needSaveNumber();
        }

        public void doneSaving(ISaveContext context) {
            int prevNum = context.getPreviousSaveNumber();
            IPath prevSavePath = new Path("sites").addFileExtension(Integer.toString(prevNum));
            SyncingPlugin.this.getStateLocation().append(prevSavePath).toFile().delete();
            prevSavePath = new Path("defaultConnection").addFileExtension(Integer.toString(prevNum));
            SyncingPlugin.this.getStateLocation().append(prevSavePath).toFile().delete();
        }

        public void rollback(ISaveContext context) {
            int saveNum = context.getSaveNumber();
            IPath savePath = new Path("sites").addFileExtension(Integer.toString(saveNum));
            SyncingPlugin.this.getStateLocation().append(savePath).toFile().delete();
            savePath = new Path("defaultConnection").addFileExtension(Integer.toString(saveNum));
            SyncingPlugin.this.getStateLocation().append(savePath).toFile().delete();
        }
    }
}

